// /* eslint-disable no-undef, no-unused-vars */
// require('./utils/string'); // load generic string prototypes

function createModule(config) {
  /**
   * @fileoverview This file contains the ncore module, which sets up the runtime environment and exports various utilities.
   * @module ncore
   */
  let $$ = require('/agorum/roi/customers/cdev.ncore/js/utils/debug')(config);
  let environment = Object.assign({}, $$.environment); // copy of environment object
  let print = $$.print;     // unconditional output
  let debug = $$.debug;     // conditional output according to debug flag
  let enable = $$.enable;   // enable debugging
  let disable = $$.disable; // disable debugging
  let list = $$.list;       // list debug cache settings
  let clear = $$.clear;     // clear debug cache settings
  let cache = $$.cache;     // cache object
  let os, ocr, pdf, objects, beans, metadata, md, mdb, i18n, property, log, DEBUG, api, solr;
  let obj = require('/agorum/roi/customers/cdev.ncore/js/utils/obj');
  let fs = require('/agorum/roi/customers/cdev.ncore/js/utils/fs');
  let cpackage = require('/agorum/roi/customers/cdev.ncore/js/utils/package');

  if (typeof process !== 'undefined') {
    ////////////////////////////////////////////
    // setup nodejs based runtime environment //
    ////////////////////////////////////////////
    /**
     * Log a message to the console.
     * @param {string} msg - The message to be logged.
     */
    let tokens = __dirname.split('/');
    environment.package = tokens.length > 4 ? tokens[4] : __dirname;
    environment.file = tokens[tokens.length - 1].replace('.js', '');
    log = msg => {      
      console.log(environment.package, msg);
    };
  } else {
    //////////////////////////////////////////////////
    // setup agorum/Rhino based runtime environment //
    //////////////////////////////////////////////////
    objects = require('common/objects');
    beans = require('common/beans');
    property = require('common/property');
    metadata = require('common/metadata');
    // cache = require('common/cache')('CDEV_NCORE');
    i18n = require('common/i18n');
    md = require('/agorum/roi/customers/cdev.ncore/js/utils/md');
    mdb = require('/agorum/roi/customers/cdev.ncore/js/utils/mdb');
    os = require('/agorum/roi/customers/cdev.ncore/js/utils/os');
    ocr = require('/agorum/roi/customers/cdev.ncore/js/utils/ocr');
    pdf = require('/agorum/roi/customers/cdev.ncore/js/utils/pdf');
    api = require('/agorum/roi/customers/cdev.ncore/js/utils/api');
    solr = require('/agorum/roi/customers/cdev.ncore/js/utils/solr');
    DEBUG = require('/agorum/roi/customers/cdev.ncore/js/DEBUG');
    /**
     * Log a message to the agorum server.log.
     * @param {string} msg - The message to be logged.
     */
    log = msg => {
      environment.package || (environment.package = cpackage(module.id));
      global.Packages.agorum.commons.logging.Log.info(
        environment.package.name + '[' + global.sc.loginUser.name + ']: ' + msg
      );
    };
  }

  /**
   * The ncore module exports the following utilities:
   * @exports ncore
   */
  return {
    environment: environment,
    DEBUG: DEBUG,
    log: log,
    print: print,
    debug: debug,
    enable: enable,
    disable: disable,
    list: list,
    clear: clear,
    cache: cache,
    package: cpackage,
    fs: fs,
    obj: obj,
    md: md,
    mdb: mdb,
    os: os,
    ocr: ocr,
    pdf: pdf,
    api: api,
    solr: solr,
    objects: objects,
    beans: beans,
    property: property,
    metadata: metadata,
    cache: cache,
    i18n: i18n,
    translate: key => {
      return i18n.translate(key);
    },
  };
}

// Erstelle das Standardmodul
let defaultModule = createModule();

// Füge die Konfigurationsfunktion zum Standardmodul hinzu
defaultModule.configure = function (config) {
  return createModule(config);
};

// Exportiere als Objekt und als Funktion
module.exports = Object.assign(function (config) {
  return createModule(config);
}, defaultModule);
